import { useState, useEffect } from 'react'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import './ImageSlider.css'

function ImageSlider({ images }) {
  const [currentIndex, setCurrentIndex] = useState(0)

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <section className="image-slider">
      <div className="slider-container">
        <div className="slider-wrapper" style={{ transform: `translateX(-${currentIndex * 100}%)` }}>
          {images.map((image, index) => (
            <div 
              key={index} 
              className="slide"
              style={{
                backgroundImage: `url(${image}), linear-gradient(135deg, #FF6B35 0%, #F7931E 50%, #FFB84D 100%)`,
                backgroundSize: 'cover',
                backgroundPosition: 'center'
              }}
            >
              <img 
                src={image} 
                alt={`Кулинарный мастер-класс ${index + 1}`} 
                className="slide-image"
                onError={(e) => {
                  e.target.style.display = 'none'
                }}
              />
              <div className="slide-overlay"></div>
            </div>
          ))}
        </div>
        <button className="slider-btn slider-btn-prev" onClick={goToPrevious}>
          <ChevronLeft className="slider-icon" size={24} />
        </button>
        <button className="slider-btn slider-btn-next" onClick={goToNext}>
          <ChevronRight className="slider-icon" size={24} />
        </button>
        <div className="slider-indicators">
          {images.map((_, index) => (
            <button
              key={index}
              className={`indicator ${index === currentIndex ? 'active' : ''}`}
              onClick={() => goToSlide(index)}
              aria-label={`Перейти к слайду ${index + 1}`}
            />
          ))}
        </div>
      </div>
    </section>
  )
}

export default ImageSlider

